/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.FigureEnumeration;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.PrintImageFigure;
import DE.siemens.ad.pdraw.figures.constraints.BlockConstraint;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.UDFOutputIfcFigure;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;

public class UDFBlockFigure
extends BlockFigure {
    private static final long serialVersionUID = -3977601048836142646L;

    public UDFBlockFigure() {
    }

    public UDFBlockFigure(UDFBlock block, Point origin) {
        super(block, origin);
    }

    protected void addImageFigure() {
        BufferedImage image = new BufferedImage(36, 42, 5);
        UDFBlockImageFigure imageFigure = new UDFBlockImageFigure(image, null, new Point(this.fDisplayBox.x, this.fDisplayBox.y));
        this.add(imageFigure, "imageFigureGroup");
    }

    protected void layoutImageFigure() {
        List outConnectorGroup;
        ImageFigure imageFigure = this.getImageFigure();
        Rectangle imageBox = imageFigure.displayBox();
        int inputCount = 0;
        int outputCount = 0;
        List inConnectorGroup = (List)this.getGroupFiguresMap().get("inConnectorFigureGroup");
        if (inConnectorGroup != null) {
            inputCount = inConnectorGroup.size();
        }
        if ((outConnectorGroup = (List)this.getGroupFiguresMap().get("outConnectorFigureGroup")) != null) {
            outputCount = outConnectorGroup.size();
        }
        int maxConnector = inputCount > outputCount ? inputCount : outputCount;
        imageBox.height = maxConnector < 4 ? 42 : 42 + (maxConnector - 3) * 10;
        imageFigure.basicDisplayBox(imageBox);
    }

    public void drawSimulation1(Graphics g) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().drawSimulation1(g);
        }
        boolean binaryConnector = false;
        boolean hasFalseValue = false;
        boolean hasTrueValue = false;
        Block block = this.getBlock();
        OutBlockConnector[] conArr = block.getOutConnectors();
        for (int j = 0; j < conArr.length; ++j) {
            if (!(conArr[j] instanceof BinaryOutBlockConnector)) continue;
            binaryConnector = true;
            BlockConnector innerOutConnctor = ((UDFBlock)block).getFirstBlockOutputConnector(conArr[j]);
            if (((BinaryOutBlockConnector)innerOutConnctor).getOwner().getBinaryValue()) {
                hasTrueValue = true;
                ((BinaryOutBlockConnector)conArr[j]).setBinaryValue(true);
                continue;
            }
            hasFalseValue = true;
            ((BinaryOutBlockConnector)conArr[j]).setBinaryValue(false);
        }
        Color oldColor = this.fBorderColor;
        if (binaryConnector) {
            this.fBorderColor = hasTrueValue && !hasFalseValue ? Global.SIMULATION_COLOR_HIGH : (hasTrueValue && hasFalseValue ? Global.SIMULATION_COLOR_UDF : Global.SIMULATION_COLOR_LOW);
        }
        ImageFigure iF = this.getImageFigure();
        Rectangle r = null;
        if (iF != null) {
            r = iF.displayBox();
            g.setColor(this.fBorderColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        this.fBorderColor = oldColor;
    }

    public void drawSimulation2(Graphics g) {
        UDFBlock block = (UDFBlock)this.getBlock();
        this.getCurrentParameterTextFigure();
        Point currentValuePosition = this.getCurrentParmeterTextPosition();
        this.fTmpParameterTextFigure.basicDisplayBox(currentValuePosition, currentValuePosition);
        UDFBlockParameter blockParameter = (UDFBlockParameter)block.getParameter();
        String parameterText = "";
        if (blockParameter != null) {
            parameterText = blockParameter.calculateCurrentParameterText();
        }
        this.fTmpParameterTextFigure.setText(parameterText);
        this.fTmpParameterTextFigure.draw(g);
    }

    protected void addOutputFigure(OutBlockConnector outBlockConnector) {
        UDFOutputIfcFigure outputFigure = new UDFOutputIfcFigure(outBlockConnector);
        outputFigure.getConstraint().setContainer((BlockConstraint)this.getConstraint());
        this.add(outputFigure, "outConnectorFigureGroup");
    }

    public static class UDFBlockImageFigure
    extends PrintImageFigure {
        private static final long serialVersionUID = 1L;

        public UDFBlockImageFigure() {
        }

        public UDFBlockImageFigure(Image image, String fileName, Point origin) {
            super(image, fileName, origin);
        }

        protected void drawGhost(Graphics g, BlockFigure blockFigure) {
            super.drawGhost(g, blockFigure);
            Rectangle rect = this.displayBox();
            String identifier = ((UDFBlock)blockFigure.getBlock()).getIdentifier();
            if (identifier.length() > 5) {
                identifier = identifier.substring(0, 5);
            }
            Font f = g.getFont();
            g.setFont(new Font("Courier", 0, 12));
            Rectangle identifierRect = g.getFontMetrics().getStringBounds(identifier, g).getBounds();
            int xOff = (rect.width - identifierRect.width) / 2;
            int yOff = (rect.height / 3 - identifierRect.height) / 2;
            g.drawString(identifier, rect.x + xOff, rect.y + rect.height - yOff - identifierRect.height + 8);
            g.setFont(f);
            int state = UDFFactory.instance().getUDFBlockState(((UDFBlock)blockFigure.getBlock()).getGuid());
            if (state == 0) {
                g.setColor(Color.green);
                int radias = 6;
                int x = rect.x + rect.width - radias * 2 - 2;
                int y = rect.y + 4;
                g.fillOval(x, y, radias * 2, radias * 2);
            } else if (state == 2) {
                g.setColor(Color.red);
                int x = rect.x + rect.width - 12;
                int y = rect.y + 16;
                Font oldFont = g.getFont();
                g.setFont(new Font("Default", 1, 16));
                g.drawString("?", x, y);
                g.setFont(oldFont);
            } else if (state == 1) {
                g.setColor(Color.red);
                int radias = 5;
                int width = 2;
                int x = rect.x + rect.width - radias - width - 2;
                int y = rect.y + 4;
                g.fillRect(x, y, width, 9);
                g.fillRect(x, y + 11, width, 2);
            }
        }
    }
}

